% This function is used to implement iterative refinement
%
% x=iterna(a,l,u,p,f);
%
% programmer: C. Vuik, TU Delft, The Netherlands
% e-mail    : c.vuik@math.tudelft.nl
% date      : 04-06-1998
% course    : Numerieke stromingsleer II (a PhD course from the J.M
%             Burgers Centre)
%

function x=iterna(a,l,u,p,f);
clear r y
format long e
r = p*f;
i = 0;
x = 0;
disp(' ')
disp(' ')
disp('     iteration                 norm of the residual')
disp('     ---------                 --------------------')
disp(' ')
disp(' ')
while norm(r) > 10^(-10) & i < 50
  i = i+1;
  y = inv(l)*r;
  x = x+inv(u)*y;
  r = f-a*x;
  disp([i,norm(r)])
end
  
