% This function is used to implement the CG iterative method
%
% x=cganal(a,f,reps);
%
% programmer: C. Vuik, TU Delft, The Netherlands
% e-mail    : c.vuik@math.tudelft.nl
% date      : 17-06-1998
% course    : Numerieke stromingsleer II (a PhD course from the J.M
%             Burgers Centre)
%

function x=cganal(a,f,reps);
close all
clear x n1 n2 n m r b
format long e
[n1 n2] = size(a);
for i = 1: n1
   xexact(i,1) = 1;
end
b = a*xexact;
xexact=inv(a)*f;
b = a*xexact;
r = f;
disp(' ')
disp(' ')
disp('     iteration                 norm of the residual')
disp('     ---------                 --------------------')
disp(' ')
disp(' ')
bnorm = norm(b);
i = 0;
x = 0*f;
r = f;
s = f;
while (norm(r)/bnorm) > reps & i < 1000
  i = i+1;
  rnormold = r'*r;
  alfa = rnormold/(s'*(a*s));
  x = x+alfa*s;
  r = r-alfa*a*s;
  beta = r'*r/rnormold;
  s = r+beta*s;
  res(i) = norm(r);
  error(i) = norm(x-xexact);
  erar(i) = sqrt((x-xexact)'*a*(x-xexact));
  disp([i,norm(r)])
end
for j = 1 : (i-1)
   fac(j) = res(j+1)/res(j);
end
res = log10(res);
error = log10(error);
erar = log10(erar);
subplot(2,2,1);
plot(res);
title(' The iterations using Conjugate Gradients')
xlabel(' iterations')
ylabel(' 10log(residu)')  
subplot(2,2,2);
plot(fac)
title(' The reduction factor |r_(i+1)|/|r_i)|')
xlabel(' iterations')
ylabel(' factor')
subplot(2,2,3);
plot(error)
title(' The norm of the error ||x_i - x ||')
xlabel(' iterations')
ylabel(' 10log(error)')
subplot(2,2,4);
plot(erar)
title(' The norm of the error ||x_i - x ||_A')
xlabel(' iterations')
ylabel(' 10log(error in A-norm)')
