% This function is used to implement the Chebychev iterative method
%
% x=cheby(a,f,reps);
%
% programmer: C. Vuik, TU Delft, The Netherlands
% e-mail    : c.vuik@math.tudelft.nl
% date      : 04-06-1998
% course    : Numerieke stromingsleer II (a PhD course from the J.M
%             Burgers Centre)
%

function x1=cheby(a,f,reps);
clear x0 x1 n1 n2 n m r u1 un
format long e
r = f;
disp(' ')
disp(' ')
disp('     iteration                 norm of the residual')
disp('     ---------                 --------------------')
disp(' ')
disp(' ')
bnorm = norm(f);
i = 0;
x0 = 0*f;
r = f;
s = f;
u1=min(eig(a));
un=max(eig(a));
i = 1;
x1 = x0 + 2/(u1+un)*r;
c0 = 1;
c1 = -(u1+un)/(un-u1);
r=f-a*x1;
res(i) = norm(r);
disp([i,norm(r)])

while (norm(r)/bnorm) > reps & i < 1000
  i = i+1;
  chulp = c1;
  c1=-2*(u1+un)/(un-u1)*c1-c0;
  c0 = chulp;
  xhulp = x1;
  x1 = x0-2*c0/c1*(u1+un)/(un-u1)*(2/(u1+un)*r+x1-x0);
  x0 = xhulp;
  r = f-a*x1;
  res(i) = norm(r);
  disp([i,norm(r)])
end
for j = 1 : (i-1)
   fac(j) = res(j+1)/res(j);
end
res = log10(res);
subplot(2,1,1);
plot(res);
title(' The iterations using the Chebychev iterative method')
xlabel(' iterations')
ylabel(' 10log(residu)')  
subplot(2,1,2);
plot(fac)
title(' The reduction factor |r_(i+1)|/|r_i)|')
xlabel(' iterations')
ylabel(' factor')
