% This function is used to make a Gaussian elimination of a matrix and
% to show the nonzero structure of the L and U matrices
%
% [l,u,p]=gauss(a);
%
% programmer: C. Vuik, TU Delft, The Netherlands
% e-mail    : c.vuik@math.tudelft.nl
% date      : 04-06-1998
% course    : Numerieke stromingsleer II (a PhD course from the J.M
%             Burgers Centre)
%

function [l,u,p]=gauss(a);
clear l u p
figure(1)
set(1,'Position',[54 120 560 420]);
clf
figure(2)
set(2,'Position',[635 120 560 420]);
clf

% With close(1) figure 1 is closed, close all closes all figure windows

pause(2);
[l,u,p]=lu(a);
[nona,banda] = nonzer(a);
[nonl,bandl] = nonzer(l);
[nonu,bandu] = nonzer(u);
disp(' ')
disp(' ')
disp(' The number of nonzero elements of a is')
disp( nona)
disp(' The bandwidth of a is')
disp(banda)
disp(' The number of nonzero elements of l is')
disp( nonl)
disp(' The bandwidth of l is')
disp(bandl)
disp(' The number of nonzero elements of u is')
disp( nonu)
disp(' The bandwidth of u is')
disp(bandu)
figure(1)
hold off
%nonstruc(a);
spy(a,'k');
title('The nonzero structure of A')
pause(1);
figure(2)
hold off
%nonstruc(l);
spy(l,'b');
title('The nonzero structure of L')
pause(1);
hold on
%nonstruc(u);
spy(u,'r');
title('The nonzero structure of L+U')
hold off
