% This function is used to implement the Gauss-Jacobi iterative method
%
% x=jacobi(a,f,reps);
%
% programmer: C. Vuik, TU Delft, The Netherlands
% e-mail    : c.vuik@math.tudelft.nl
% date      : 17-06-1998
% course    : Numerieke stromingsleer II (a PhD course from the J.M
%             Burgers Centre)
%

function x=jacobi(a,f,reps);
close all
clear x n1 n2 n m r
format long e
r = f;
disp(' ')
disp(' ')
disp('     iteration                 norm of the residual')
disp('     ---------                 --------------------')
disp(' ')
disp(' ')
bnorm = norm(f);
[n1,n2] = size(a);
for i = 1 : n1
   m(i,i) = a(i,i);
   x(i,1) = 0;
end
n = m-a;
i = 0;
while (norm(r)/bnorm) > reps & i < 1000
  i = i+1;
  x = inv(m)*(n*x+f);
  r = a*x-f;
  res(i) = norm(r);
  disp([i,norm(r)])
end
res = log10(res);
plot(res);
title(' The iterations using Gauss-Jacobi')
xlabel(' iterations')
ylabel(' 10log(residu)')
