% This function is used to plot the solution obtained from the
% discretized convection diffusion equation
%
% plotsol(n1,n2,x)
%
% programmer: C. Vuik, TU Delft, The Netherlands
% e-mail    : c.vuik@math.tudelft.nl
% date      : 04-06-1998
% course    : Numerieke stromingsleer II (a PhD course from the J.M
%             Burgers Centre)
%

function plotsol(n1,n2,x);
close all
figure(1)
set(1,'Position',[54 120 560 420]);
clf
clear sol xsol ysol;
h1 = 1/(n1+1);
h2 = 1/(n2+1);
for i = 1 : n1+2
   for j = 1 : n2+2
      xsol(i,j) = (i-1)*h1;
      ysol(i,j) = (j-1)*h2;
   end
end
for i = 1 : n1+2
   sol(i,1) = 0;
   sol(i,n2+2) = 0;
end
for j = 1 : n2+2
   sol(1,j) = 0;
   sol(n1+2,j) = 0;
end
for i = 1 : n1
   for j = 1 : n2
      sol(i+1,j+1) = x(i+(j-1)*n1);
   end
end
mesh(xsol,ysol,sol)
