% This function is used to implement the SOR iterative method
%
% x=sor(a,f,reps,omega);
%
% programmer: C. Vuik, TU Delft, The Netherlands
% e-mail    : c.vuik@math.tudelft.nl
% date      : 17-06-1998
% course    : Numerieke stromingsleer II (a PhD course from the J.M
%             Burgers Centre)
%

function x=sor(a,f,reps,omega);
close all
clear x n1 n2 n m r
format long e
r = f;
disp(' ')
disp(' ')
disp('     iteration                 norm of the residual')
disp('     ---------                 --------------------')
disp(' ')
disp(' ')
bnorm = norm(f);
[n1,n2] = size(a);
omegal = omega;
if omega ==0
for i = 1 : n1
   m(i,i) = a(i,i);
   x(i,1) = 0;
   for j = 1:(i-1)
      m(i,j) = a(i,j);
   end
end
n = m-a;
mu = max(abs(eig(inv(m)*n)));
omegal = 2/(1+sqrt(1-mu));
end
for i = 1 : n1
   m(i,i) = a(i,i)/omegal;
   x(i,1) = 0;
   for j = 1:(i-1)
      m(i,j) = a(i,j);
   end
end
n = m-a;
i = 0;
while (norm(r)/bnorm) > reps & i < 1000
  i = i+1;
  x = inv(m)*(n*x+f);
  r = a*x-f;
  res(i) = norm(r);
  disp([i,norm(r)])
end
if omega ==0
   disp(' ')
   disp(' ')
   disp(' The value of the optimal omega is:')
   disp(omegal)
   disp(' ')
   disp(' ')
end
res = log10(res);
plot(res);
title(' The iterations using SOR')
xlabel(' iterations')
ylabel(' 10log(residu)')
  
